#!/usr/bin/env python3 
# -*- coding: utf-8 -*-
import os
import time
import sys
import platform  
import argparse
import subprocess
import shutil
import random

import pyCBlueUI   # 这是导入CBlueUI for Python 扩展模块。

#python事件处理函数
def do_something() :
    #获得控件对象
    ui_title = pyCBlueUI.FindControl("title", None)
    #更新文本
    ui_title.ShellAttribute("text", " this is form python code")
    #刷新控件
    ui_title.Refresh()
    return 1

# main 
if __name__=="__main__":

    os.system('')
    cur_dir = os.path.abspath('.')
    cur_dir = cur_dir.replace('\\','/')

    #初始化CBlueUI系统
    pyCBlueUI.InitializeUISystem()
    
    #控件管理器
    manager = pyCBlueUI.UIManager()
    #宿主窗口
    dlg = pyCBlueUI.WindowPlatform()
    dlg.CreatePlatform(None, "PyCBlueUI Demo", pyCBlueUI.WIDGET_VISIBLE | pyCBlueUI.WIDGET_RESIZABLE, 0,0,100,100)

    #将窗口管理器和宿主窗口连接
    dlg.InitPlatformAdapter(manager)

    #全局资源文件
    res_file = os.path.join(cur_dir, "image_def.xml") 
    pyCBlueUI.XmlBuilder.ApplyResourceWithFile(res_file, pyCBlueUI.Format_Auto)

    #主界面解析
    main_xml_file = os.path.join(cur_dir, "Install.xml") 
    build_tool = pyCBlueUI.XmlBuilder()
    build_tool.LoadUIFileA(main_xml_file, manager, None)

    #窗口居中
    dlg.CenterWindow()

    #获得控件对象
    ui_desk = pyCBlueUI.FindControl("btnInstall", None)

    if ui_desk != None:
        str_ids = ui_desk.VarName()
        # 为控件绑定事件函数
        ui_desk.BindAction(do_something) 

    dlg.DoModal(False)

    cur_time = time.strftime('%Y-%m-%d %H:%M:%S',time.localtime(time.time()))
    print("\033[33m** test pyCBlueUI with pybind11 finished. update time:{}\033[0m".format(cur_time))